using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace _3zad
{
    internal class Program
    {
        public static void QuickSort(int[] array, int low, int high)
        {
            if (low < high)
            {
                int pivotIndex = Partition(array, low, high);
                QuickSort(array, low, pivotIndex - 1);
                QuickSort(array, pivotIndex + 1, high);
            }
        }

        private static int Partition(int[] array, int low, int high)
        {
            int pivot = array[high];
            int i = low - 1;

            for (int j = low; j < high; j++)
            {
                if (array[j] <= pivot)
                {
                    i++;
                    Swap(array, i, j);
                }
            }

            Swap(array, i + 1, high);
            return i + 1;
        }

        private static void Swap(int[] array, int a, int b)
        {
            int temp = array[a];
            array[a] = array[b];
            array[b] = temp;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            int[] x = new int[n];
            int[] h = new int[n];
            double a;
            string[] s = Console.ReadLine().Split(' ');
            for (int i = 0; i < n; i++)
            {
                x[i] = int.Parse(s[i]);
            }
            s = Console.ReadLine().Split();
            for (int i = 0; i < n; i++)
            {
                h[i] = int.Parse(s[i]);
            }
            QuickSort(x, 0, n - 1);
            double dmin = -1;
            for (int i = 0; i < n; i++)
            {
                dmin = -1;
                for (int j = 0; j < n; j++)
                {
                    if (i == j) continue;
                    if (h[i] <= h[j])
                    {
                        double d = Math.Abs(x[i] - x[j]);
                        if (d < dmin || dmin < 0) dmin = d;
                    }
                }
                for (int j = 0; j < n - 1; j++)
                {
                    double x1 = x[j]; double y1 = h[j];
                    double x2 = x[j + 1]; double y2 = h[j + 1];
                    double xp = (x1 +x2 + y1 - y2) / 2.0;
                    double yp = y1 - (xp - x1);
                    if (h[i] > Math.Max(y1, y2) || h[i] < yp || x[i] == x2) continue;
                    if (y1 < y2)
                    {
                            if (h[i] >= y1)
                            {
                                Double X = (xp - yp) + h[i];
                                if (X >= xp && X <= x2)
                                {
                                    double d = Math.Abs(X - x[i]);
                                    if (dmin < 0 || d < dmin) dmin = d;
                                }
                            }
                            else
                            {
                                Double X = (xp + yp) - h[i];
                                if (x1 <= X && X <= xp)
                                {
                                    double d = Math.Abs(X - x[i]);
                                    if (dmin < 0 || d < dmin) dmin = d;
                                }
                            }
                    }
                    else
                    {
                        if (h[i] >= y1)
                        {
                            Double X = (xp + yp) - h[i];
                            if (x1 <= X && X <= xp)
                            {
                                double d = Math.Abs(X - x[i]);
                                if (dmin < 0 || d < dmin) dmin = d;
                            }
                        }
                        else
                        {
                            Double X = (xp - yp) + h[i];
                            if (xp <= X && X <= x2)
                            {
                                double d = Math.Abs(X - x[i]);
                                if (dmin < 0 || d < dmin) dmin = d;
                            }
                        }
                    }
                }
                if (dmin < 0) Console.WriteLine(-1);
                else Console.WriteLine(dmin);
            }
            Console.ReadLine();
        }
    }
}